using System;
using System.ComponentModel.Composition;
using VRM.Integration.Servicebus.Core;
using VRM.Integration.Servicebus.Logging.CRM.Util;
using VIMT.VirtualMeetingRoom.Messages;
using VIMT.VirtualMeetingRoom.Processors;

namespace VIMT.VirtualMeetingRoom.MessageHandler
{
	[Export(typeof(IMessageHandler))]
	[ExportMetadata("MessageType", MessageRegistry.VIMTVirtualDeleteMeetingRequest)]
	/// <summary>
	/// VIMT Enterprise Component for VIMT.VirtualMeetingRoom,DeleteMeeting method, MessageHandler.
	/// Code Generated by IMS on: 4/12/2016 6:50:07 PM
	/// Version: 2016.04.08
	/// </summary>
	/// <param name=none></param>
	/// <returns>none</returns>
	public class VIMTVirtualDeleteMeetingMessageHandler : RequestResponseHandler
	{
		public override IMessageBase HandleRequestResponse(object message)
		{
			try
			{
				LogMessageReceipt(message);
				var processor = new DeleteMeetingProcessor();
				return processor.Execute((VIMTVirtualDeleteMeetingRequest)message);
			}
			catch (Exception ex)
			{
				VIMTVirtualDeleteMeetingRequest msg = (VIMTVirtualDeleteMeetingRequest)message;
				LogHelper.LogError(msg.OrganizationName, msg.UserId, "DeleteMeetingMessageHandler.HandleRequestResponse", ex);
				throw new Exception(string.Format("VIMTVirtualDeleteMeetingMessageHandler Error: {0}", ex.Message), ex);
			}
		}
	}
}
